*                                                                                  ;
 *    Reading in the 1969 PSID data                                                 ;
 *                                                                                  ;
 *            Karen Dynan 8/26/06                                                   ;
 *                                                                                  ;
 *    We read it all in and then output select variables to a flat                  ;
 *    file to be picked up by STATA.                                                ;
 *                                                                                  ;
 
libname psid 'F:\PSID\extract' ;
filename rawdat 'F:\PSID\raw\fam70.raw' ;
 
 data one;
 
   infile 'F:\PSID\70FAM.DAT'  lrecl=1135 missover;
   INPUT
   V1101 1-3              V1102 4-7              V1103 8-9
   V1104 10-12            V1105 13-17            V1106 18
   V1107 19               V1108 20               V1109 21
   V1110 22               V1111 23               V1112 24
   V1113 25               V1114 26               V1115 27
   V1116 28-31            V1117 32               V1118 33-35
   V1119 36               V1120 37-39            V1121 40
   V1122 41-45            V1123 46               V1124 47-51
   V1125 52               V1126 53-56            V1127 57
   V1128 58-61            V1129 62               V1130 63-66
   V1131 67               V1132 68               V1133 69-72
   V1134 73               V1135 74-77            V1136 78
   V1137 79-82            V1138 83-86            V1139 87
   V1140 88-91            V1141 92               V1142 93-96
   V1143 97               V1144 98-101           V1145 102
   V1146 103-105          V1147 106              V1148 107-110
   V1149 111              V1150 112-115          V1151 116
   V1152 117-119          V1153 120              V1154 121-124
   V1155 125              V1156 126-129          V1157 130
   V1158 131-134          V1159 135              V1160 136-139
   V1161 140              V1162 141-144          V1163 145
   V1164 146-149          V1165 150              V1166 151
   V1167 152-153          V1168 154              V1169 155-159 .2
   V1170 160-164          V1171 165-168          V1172 169
   V1173 170-172          V1174 173              V1175 174-177
   V1176 178              V1177 179-182          V1178 183
   V1179 184-187          V1180 188              V1181 189-192
   V1182 193              V1183 194-197          V1184 198
   V1185 199-202          V1186 203              V1187 204-207
   V1188 208              V1189 209              V1190 210
   V1191 211-215          V1192 216              V1193 217
   V1194 218              V1195 219              V1196 220-224
   V1197 225              V1198 226-230          V1199 231
   V1200 232              V1201 233              V1202 234
   V1203 235              V1204 236              V1205 237-241
   V1206 242              V1207 243              V1208 244-248
   V1209 249-253          V1210 254              V1211 255-259
   V1212 260-264          V1213 265-269          V1214 270-274
   V1215 275-279          V1216 280              V1217 281
   V1218 282              V1219 283              V1220 284-288
   V1221 289-292          V1222 293-297          V1223 298
   V1224 299-303          V1225 304-308          V1226 309
   V1227 310              V1228 311-315          V1229 316-319
   V1230 320-323          V1231 324-326          V1232 327
   V1233 328-331          V1234 332-340          V1235 341-342
   V1236 343              V1237 344-346          V1238 347-348
   V1239 349-350          V1240 351              V1241 352-353
   V1242 354              V1243 355-356          V1244 357
   V1245 358              V1246 359              V1247 360
   V1248 361              V1249 362              V1250 363
   V1251 364              V1252 365              V1253 366
   V1254 367              V1255 368-369          V1256 370
   V1257 371              V1258 372              V1259 373
   V1260 374              V1261 375              V1262 376
   V1263 377              V1264 378              V1265 379
   V1266 380              V1267 381              V1268 382
   V1269 383              V1270 384              V1271 385
   V1272 386              V1273 387              V1274 388
   V1275 389              V1276 390              V1277 391
   V1278 392              V1279 393              V1280 394
   V1281 395              V1282 396              V1283 397
   V1284 398              V1285 399              V1286 400
   V1287 401-402          V1288 403              V1289 404-405
   V1290 406              V1291 407-408          V1292 409-410
   V1293 411-412          V1294 413              V1295 414-416
   V1296 417              V1297 418-420          V1298 421
   V1299 422              V1300 423              V1301 424-426
   V1302 427-428          V1303 429-430          V1304 431
   V1305 432              V1306 433              V1307 434
   V1308 435              V1309 436-437          V1310 438
   V1311 439              V1312 440              V1313 441
   V1314 442              V1315 443              V1316 444-446
   V1317 447              V1318 448              V1319 449
   V1320 450              V1321 451-453          V1322 454
   V1323 455              V1324 456              V1325 457
   V1326 458              V1327 459-461          V1328 462
   V1329 463              V1330 464              V1331 465
   V1332 466              V1333 467-468          V1334 469-470
   V1335 471-472          V1336 473-474          V1337 475
   V1338 476-477          V1339 478              V1340 479
   V1341 480              V1342 481              V1343 482
   V1344 483-485          V1345 486              V1346 487-489
   V1347 490              V1348 491              V1349 492
   V1350 493              V1351 494              V1352 495
   V1353 496-497          V1354 498-499          V1355 500
   V1356 501              V1357 502-504          V1358 505
   V1359 506              V1360 507              V1361 508
   V1362 509-511          V1363 512              V1364 513
   V1365 514              V1366 515              V1367 516
   V1368 517-518          V1369 519-520          V1370 521
   V1371 522              V1372 523              V1373 524
   V1374 525              V1375 526              V1376 527-528
   V1377 529              V1378 530              V1379 531
   V1380 532              V1381 533              V1382 534
   V1383 535              V1384 536              V1385 537
   V1386 538              V1387 539              V1388 540
   V1389 541              V1390 542              V1391 543
   V1392 544              V1393_1 545            V1393_2 546
   V1394 547              V1395 548              V1396 549
   V1397 550              V1398_1 551            V1398_2 552
   V1399 553              V1400 554              V1401 555
   V1402 556              V1403 557              V1404 558
   V1405 559              V1406 560              V1407 561
   V1408 562              V1409 563              V1410 564
   V1411 565              V1412 566              V1413 567
   V1414 568              V1415 569              V1416 570-571
   V1417 572              V1418 573              V1419 574
   V1420 575-576          V1421 577              V1422 578
   V1423 579              V1424_1 580            V1424_2 581
   V1425 582              V1426 583              V1427 584
   V1428 585              V1429 586              V1430 587
   V1431 588              V1432 589              V1433 590
   V1434 591              V1435 592              V1436 593
   V1437 594              V1438 595              V1439 596
   V1440 597              V1441 598              V1442 599
   V1443 600              V1444 601              V1445 602
   V1446 603              V1447 604              V1448 605
   V1449 606              V1450 607              V1451 608
   V1452 609              V1453 610              V1454 611-612
   V1455 613-615          V1456 616-617          V1457 618-620
   V1458 621              V1459 622              V1460 623
   V1461 624              V1462 625-626          V1463 627-628
   V1464 629-630          V1465 631-632          V1466 633
   V1467 634              V1468 635              V1469 636-637
   V1470 638              V1471 639              V1472 640
   V1473 641-642          V1474 643              V1475 644
   V1476 645              V1477 646-647          V1478 648-650
   V1479 651              V1480 652              V1481 653
   V1482 654              V1483 655              V1484 656
   V1485 657              V1486 658              V1487 659
   V1488 660              V1489 661              V1490 662
   V1491 663              V1492 664              V1493 665
   V1494 666              V1495 667              V1496 668
   V1497 669-671          V1498 672              V1499 673
   V1500 674              V1501 675              V1502 676
   V1503 677              V1504 678              V1505 679
   V1506 680              V1507 681-684          V1508 685-688
   V1509 689-692          V1510 693-696          V1511 697
   V1512 698-701          V1513 702-705          V1514 706-710
   V1515 711              V1516 712              V1517 713
   V1518 714              V1519 715              V1520 716
   V1521 717              V1522 718              V1523 719
   V1524 720              V1525 721              V1526 722
   V1527 723-727          V1528 728              V1529 729
   V1530 730-733 .2       V1531 734              V1532 735-737
   V1533 738              V1534 739-742          V1535 743-747
   V1536 748              V1537 749-753          V1538 754-758
   V1539 759              V1540 760-763 .2       V1541 764
   V1542 765-767          V1543 768              V1544 769-772
   V1545 773              V1546 774-778          V1547 779
   V1548 780-783 .2       V1549 784              V1550 785-787
   V1551 788              V1552 789-793          V1553 794
   V1554 795-798 .2       V1555 799              V1556 800-802
   V1557 803              V1558 804-806          V1559 807-810
   V1560 811              V1561 812-815 .2       V1562 816
   V1563 817-820          V1564 821              V1565 822-825
   V1566 826              V1567 827-830 .2       V1568 831
   V1569 832-835 .2       V1570 836              V1571 837
   V1572 838              V1573 839              V1574 840
   V1575 841              V1576 842              V1577 843
   V1578 844              V1579 845              V1580 846-847
   V1581 848-849          V1582 850-854          V1583 855
   V1584 856              V1585 857              V1586 858
   V1587 859              V1588 860              V1589 861-862 .1
   V1590 863              V1591 864-865          V1592 866-869
   V1593 870              V1594 871              V1595 872
   V1596 873              V1597 874              V1598 875
   V1599 876              V1600 877              V1601 878
   V1602 879              V1603 880              V1604 881-884
   V1605 885-888          V1606 889              V1607 890
   V1608 891              V1609 892-893          V1610 894
   V1611 895              V1612 896              V1613 897
   V1614 898              V1615 899              V1616 900
   V1617 901              V1618 902              V1619 903
   V1620 904              V1621 905              V1622 906
   V1623 907              V1624 908              V1625 909
   V1626 910              V1627 911              V1701 912-916
   V1702 917-920 .1       V1703 921-924 .1       V1704 925-927 .1
   V1705 928-930 .1       V1706 931-933 .1       V1707 934-936 .1
   V1708 937-939 .1       V1709 940-942 .1       V1710 943-945 .1
   V1711 946-950          V1712 951-955          V1713 956-958 .1
   V1714 959-962 .1       V1715 963-964 .1       V1716 965-967 .1
   V1717 968-970 .1       V1718 971-973 .1       V1719 974-976 .1
   V1720 977-981          V1721 982-984          V1722 985-987 .1
   V1723 988-991          V1724 992-994 .1       V1725 995-999
   V1726 1000-1003 .1     V1727 1004-1007 .1     V1728 1008-1010 .1
   V1729 1011-1013 .1     V1730 1014-1016 .1     V1731 1017-1019 .1
   V1732 1020-1022 .1     V1733 1023-1025 .1     V1734 1026-1028 .1
   V1735 1029-1033        V1736 1034-1038        V1737 1039-1041 .1
   V1738 1042-1045 .1     V1739 1046-1047 .1     V1740 1048-1050 .1
   V1741 1051-1053 .1     V1742 1054-1056 .1     V1743 1057-1059 .1
   V1744 1060-1064        V1745 1065-1067        V1746 1068-1070 .1
   V1747 1071-1074        V1748 1075-1077 .1     V1749 1078-1080
   V1750 1081-1083        V1751 1084-1086        V1752 1087-1089
   V1753 1090-1092        V1754 1093-1095        V1755 1096-1098
   V1756 1099-1101        V1757 1102-1104        V1758 1105-1107
   V1759 1108-1110        V1760 1111-1113        V1761 1114-1116
   V1762 1117-1119        V1763 1120-1122        V1764 1123-1126
   V1765 1127-1130        V1766 1131-1134        V1767 1135;

* SAS LABEL STATEMENT;

LABEL
   V1101 = "STUDY 768(WAVE 3)"
   V1102 = "1970 INT #        21:6-9"
   V1103 = "STATE NOW      21:10-11"
   V1104 = "COUNTY NOW     21:12-14"
   V1105 = "ST+CNTY NOW    21:10-14"
   V1106 = "COVERSHEET COLOR 21:15"
   V1107 = "ONCE REFUSED     21:16"
   V1108 = "PHONE INTERVIEW  21:17"
   V1109 = "CHANGE IN FU COMP 21:18"
   V1110 = "# MOVED INTO FU   21:19"
   V1111 = "REL-HEAD:MOVER IN 21:20"
   V1112 = "# MOVED OUT OF FU 21:21"
   V1113 = "REL-HEAD:MOVER OUT 21:22"
   V1114 = "70 FU COMPOSITION  21:23"
   V1115 = "QUALITY OF MATCH   21:24"
   V1116 = "VALUE OF CARS  21:25-28"
   V1117 = "ACCURACY CAR VALUE 21:29"
   V1118 = "SAVE CAR REPAIR 21:30-32"
   V1119 = "ACC OF SAVD CAR 21:33"
   V1120 = "HRS CAR REPAIR  21:34-36"
   V1121 = "ACC HRS CAR REPAIR 21:37"
   V1122 = "HOUSE VALUE     21:38-42"
   V1123 = "ACC HOUSE VALUE 21:43"
   V1124 = "REM MORT PRINC  21:44-48"
   V1125 = "ACC REM MORT PRINC 21:49"
   V1126 = "ANNUAL MORT PAY 21:50-53"
   V1127 = "ACC MORT PAY    21:54"
   V1128 = "ANNUAL RENT     21:55-58"
   V1129 = "ACC ANNUAL RENT 21:59"
   V1130 = "ANNUAL RENT VAL 21:60-63"
   V1131 = "ACC ANNUAL RENT VAL21:64"
   V1132 = "CODE:WK FOR HOUSE  21:65"
   V1133 = "ANNUAL UTILITIES21:66-69"
   V1134 = "ACC UTILITIES   21:70"
   V1135 = "$  SAVE ON A& R   21:71-74"
   V1136 = "ACC $  SAVED A& R 21:75"
   V1137 = "HOME PROD HRS   21:76-79"
   V1138 = "HRS HEAD WORKED 22:10-13"
   V1139 = "ACC HRS HEAD WKD 22:14"
   V1140 = "HRS HEAD ILL    22:15-18"
   V1141 = "ACC HRS HEAD ILL   22:19"
   V1142 = "HRS HEAD UNEMP  22:20-23"
   V1143 = "ACC HRS HEAD UNEMP 22:24"
   V1144 = "$  HEAD TRVL WR  22:25-28"
   V1145 = "ACC $  HEAD TRVL 22:29"
   V1146 = "HRS HEAD TRVL WK22:30-32"
   V1147 = "ACC HRS HEAD TR WK 22:33"
   V1148 = "HRS WIFE WORKED 22:34-37"
   V1149 = "ACC HRS WIFE WK 22:38"
   V1150 = "$  WIFE TRVL WK  22:39-42"
   V1151 = "ACC $  WIFE TR WK 22:43"
   V1152 = "HRS WF TRVL WK  22:44-46"
   V1153 = "ACC HRS WF TRVL WK 22:47"
   V1154 = "HRS HSWRK 1ST   22:48-51"
   V1155 = "ACC HRS HSWRK 1ST 22:52"
   V1156 = "HRS HSWRK HUSBND22:53-56"
   V1157 = "ACC HSWRK HUSBND- 22:57"
   V1158 = "HRS HSWRK OTHER 22:58-61"
   V1159 = "ACC HRS HSWRK OTHRS22:62"
   V1160 = "$    HSWRK NONFU 22:63-66"
   V1161 = "ACC $  HSWRK NONFU  22:67"
   V1162 = "HRS HSWRK NONFU 22:68-71"
   V1163 = "ACC HRS HSWRK NONFU22:72"
   V1164 = "COST CHILD CARE 22:73-76"
   V1165 = "ACC $  CHILD CARE 22:77"
   V1166 = "# MAJOR ADULTS  22:78"
   V1167 = "# IN FU         23:10-11"
   V1168 = "# REQUIRED ROOMS 23:12"
   V1169 = "FU WKLY FOOD STD23:13-17"
   V1170 = "ANNUAL NEED STD 23:18-22"
   V1171 = "$  ANNUAL ALCOHOL23:23-26"
   V1172 = "ACC $  ANN ALCOHOL 23:27"
   V1173 = "$  ANNUAL CIGS   23:28-30"
   V1174 = "ACC $  ANN CIGARETTE23:31"
   V1175 = "$  FOOD USED HOME23:32-35"
   V1176 = "ACC $  FOOD HOME 23:36"
   V1177 = "$  MEALS WRK/SCH 23:37-40"
   V1178 = "ACC $  MEALS W/S 23:41"
   V1179 = "$  SAVD GROW FOOD23:42-45"
   V1180 = "ACC $  SAVD GROW FD 23:46"
   V1181 = "$  SAVD WRK/SCH  23:47-50"
   V1182 = "ACC $  SAVD WRK/SCH 23:51"
   V1183 = "$  SAVD FOOD STMP23:52-55"
   V1184 = "ACC $  SAVD FD STMP 23:56"
   V1185 = "$  EATING OUT    23:57-60"
   V1186 = "ACC $  EATING OUT 23:61"
   V1187 = "$  SAVD OTHER FD 23:62-65"
   V1188 = "ACC $  SAVD OTHER FD23:66"
   V1189 = "BKT LABOR FARM Y   24:10"
   V1190 = "BKT LABOR BUS.Y    24:11"
   V1191 = "HEAD WAGES      24:12-16"
   V1192 = "ACC HEAD WAGES  24:17"
   V1193 = "BKT BONUS,OVERTIME 24:18"
   V1194 = "BKT PROF.PRACT,TRD 24:19"
   V1195 = "BKT LABOR ROOMER Y 24:20"
   V1196 = "LABOR INC HEAD  24:21-25"
   V1197 = "ACC LABOR Y HEAD   24:26"
   V1198 = "LABOR INC WIFE  24:27-31"
   V1199 = "ACC LABOR Y WIFE   24:32"
   V1200 = "BKT ASSET FARM Y   24:33"
   V1201 = "BKT ASSET BUS. Y   24:34"
   V1202 = "BKT ASSET ROOMER Y 24:35"
   V1203 = "BKT RENT,DIV,INT   24:36"
   V1204 = "BKT WIFE ASSET Y   24:37"
   V1205 = "H+W TAXABLE INC 24:38-42"
   V1206 = "ACC H& W TXB INC    24:43"
   V1207 = "# DEPENDENTS H+W   24:44"
   V1208 = "TAXES  OF H& W   24:45-49"
   V1209 = "ADC,AFDC H& W    25:10-14"
   V1210 = "ACC ADC H& W     25:15"
   V1211 = "OTHER WELFARE   25:16-20"
   V1212 = "SOCIAL SECURITY 25:21-25"
   V1213 = "OTHER RETIREMENT25:26-30"
   V1214 = "UNEMP,WRK.COMP  25:31-35"
   V1215 = "ALIMONY,CHLD SPT25:36-40"
   V1216 = "BKT HELP FROM REL. 25:41"
   V1217 = "BKT ANYTHING ELSE  25:42"
   V1218 = "BKT WIFE TRANSFERS 25:43"
   V1219 = "ACC MISC TRANSFERS 25:44"
   V1220 = "TRANSFER Y H+W  25:45-49"
   V1221 = "HOURS WRK OTHERS25:50-53"
   V1222 = "TAXBL INC OTHERS25:54-58"
   V1223 = "ACC TXBL Y OTH  25:59"
   V1224 = "OTHERS TAXES    25:60-64"
   V1225 = "OTHERS TRANSFER 25:65-69"
   V1226 = "ACC OTHER TRANS Y 25:70"
   V1227 = "# OTHER Y RECEIVERS25:71"
   V1228 = "$  CNTRB OUT FU  25:72-76"
   V1229 = "UNION DUES DUES 25:77-80"
   V1230 = "1968 INTERVIEW# 26:10-13"
   V1231 = "ORIGINAL PSU #  26:14-16"
   V1232 = "PSU-HUNDREDS DIGIT 26:14"
   V1233 = "1969 INTERVIEW #26:17-20"
   V1234 = "IWERS SOC SEC # 26:21-29"
   V1235 = "IWERS INT #     26:30-31"
   V1236 = "DATE OF IW      26:32"
   V1237 = "LNGTH OF IW     26:33-35"
   V1238 = "# IN FU         26:36-37"
   V1239 = "AGE OF HEAD     26:38-39"
   V1240 = "SEX OF HEAD     26:40"
   V1241 = "AGE OF WIFE     26:41-42"
   V1242 = "# CHILDREN IN FU   26:43"
   V1243 = "AGE YNGST CHILD 26:44-45"
   V1244 = "ANY CHILD UNDER 25 26:46"
   V1245 = "NR CHLDRN IN SCHOOL26:47"
   V1246 = "EDUC EXPT CHILDREN 26:48"
   V1247 = "LAST PTA MTG ATTND 26:49"
   V1248 = "ANY CHILD STOP SCH 26:50"
   V1249 = "PUBLIC TRANSP AVAIL26:51"
   V1250 = "PUB TRANSP GOOD    26:52"
   V1251 = "OWN A CAR OR TRUCK 26:53"
   V1252 = "DIFFIC FR NO CAR   26:54"
   V1253 = "WHAT DIFFIC NO CAR 26:55"
   V1254 = "NR CARS OWNED      26:56"
   V1255 = "YR OF NEWEST CAR26:57:58"
   V1256 = "CONDIT NEWEST CAR  26:59"
   V1257 = "ALL CARS INSURED?  26:60"
   V1258 = "CAR HAVE SEAT BELTS26:61"
   V1259 = "SEAT BELTS FASTND  26:62"
   V1260 = "DID OWN REPAIR     26:63"
   V1261 = "KIND OF CAR REPAIR 26:64"
   V1262 = "SAVD CAR REPAIR BKT26:65"
   V1263 = "ACTUAL # ROOMS     26:66"
   V1264 = "OWN OR RENT?       26:67"
   V1265 = "MORTGAGE ?         26:68"
   V1266 = "SECOND MORTGAGE ?  26:69"
   V1267 = "WHY FREE HOUSING   26:70"
   V1268 = "WORK DONE ON HOUSE 26:71"
   V1269 = "WHAT A& R DONE ?    26:72"
   V1270 = "A& R DONE SELF      26:73"
   V1271 = "WHAT A& R DONE SELF 26:74"
   V1272 = "NR NEIGHBORS KNOWN 26:75"
   V1273 = "RELATIVES NEAR     26:76"
   V1274 = "MOVED SINCE SPRING 26:77"
   V1275 = "WHY MOVED          26:78"
   V1276 = "MIGHT MOVE         26:79"
   V1277 = "WHY MIGHT MOVE     26:80"
   V1278 = "EMPLOYMENT STATUS  27:10"
   V1279 = "OCCUPATION-HEAD(E) 27:11"
   V1280 = "SELF EMPLOYED HEAD 27:12"
   V1281 = "HOW LONG HAD JOB   27:13"
   V1282 = "HAPPENED PREV JOB  27:14"
   V1283 = "JOB PAY MORE NOW   27:15"
   V1284 = "PRESENT JOB BETTER 27:16"
   V1285 = "WHY JOB BETTER     27:17"
   V1286 = "TOOK VACATION 69(E)27:18"
   V1287 = "WKS VAC 69(E)   27:19-20"
   V1288 = "MISS WORK SICK(E)  27:21"
   V1289 = "WKS SICK 69(E)  27:22-23"
   V1290 = "UNEMPLOYED? (E)    27:24"
   V1291 = "WKS UNEMPLYD(E) 27:25-26"
   V1292 = "WKS WORK HEAD(E)27:27-28"
   V1293 = "HRS/WK WRK HD(E)27:29-30"
   V1294 = "XTRA HRS PAY? (E)  27:31"
   V1295 = "OTIM HRLY WAGE  27:32-34"
   V1296 = "WTR REG WAGE (E)   27:35"
   V1297 = "REG HRLY WAGE(E)27:36-38"
   V1298 = "EXTRA JOBS? (E)    27:39"
   V1299 = "OCCUP XTRA JOB (E) 27:40"
   V1300 = "MORE THAN 2 JOBS(E)27:41"
   V1301 = "PAY/HR EXTR WRK 27:42-44"
   V1302 = "WEEKS EXTRA JOB 27:45-46"
   V1303 = "HRS/WK XTRA JOB 27:47-48"
   V1304 = "MORE WRK AVAILABLE 27:49"
   V1305 = "WANTED MORE WORK   27:50"
   V1306 = "COULD WORK LESS    27:51"
   V1307 = "PREFRD LESS WORK   27:52"
   V1308 = "DRIVE TO WORK OR?  27:53"
   V1309 = "MILES TO WORK   27:54-55"
   V1310 = "LATE GETTNG TO WORK27:56"
   V1311 = "HOW OFTEN LATE     27:57"
   V1312 = "SKIP WORK NOT SICK 27:58"
   V1313 = "HOW OFTN SKIP WORK 27:59"
   V1314 = "MAY GET NEW JOB(E) 27:60"
   V1315 = "KIND OF NEW JOB(E) 27:61"
   V1316 = "POSSIBLE WAGE(E)27:62-64"
   V1317 = "TRNING NEW JOB (E) 27:65"
   V1318 = "DOING ABT NU JOB?  27:66"
   V1319 = "WHT DO-NEW JOB     27:67"
   V1320 = "WILLING TO MOVE JOB27:68"
   V1321 = "PAY/HR REQD MOVE27:69-71"
   V1322 = "WHY WONT MOVE JOB  27:72"
   V1323 = "CHOOSES WAY WORKS  27:73"
   V1324 = "LIKE MORE CHOICE   27:74"
   V1325 = "EMPLOYMENT STATUS  28:10"
   V1326 = "OCCUP-HEAD (U)     28:11"
   V1327 = "PAY/HR SOUGHT(U)28:12-14"
   V1328 = "TRAINING REQD (U)  28:15"
   V1329 = "HOW FINDING JOB(U) 28:16"
   V1330 = "# PLACES LOOKED(U) 28:17"
   V1331 = "OCCUP-PREVIOUS (U) 28:18"
   V1332 = "HAPPEND PREV JOB(U)28:19"
   V1333 = "WKS WKD-69 (U)  28:20-21"
   V1334 = "HRS/WK WRK-69(U)28:22-23"
   V1335 = "WKS SICK-69 (U) 28:24-25"
   V1336 = "WKS UNEMPLYD(U) 28:26-27"
   V1337 = "DRIVE TO WRK OR?(U)28:28"
   V1338 = "MILES TO WRK (U)28:29-30"
   V1339 = "LATE TO WORK (U)   28:31"
   V1340 = "HOW OFTEN LATE(U)  28:32"
   V1341 = "SKP WRK-NOT SICK(U)28:33"
   V1342 = "HOW OFTN SKIP WK(U)28:34"
   V1343 = "JOBS NOT WRTH IT(U)28:35"
   V1344 = "PAY/HR REJECT(U)28:36-38"
   V1345 = "WILLNG MOVE JOB(U) 28:39"
   V1346 = "PAY/HR REQD-MOVE28:40-42"
   V1347 = "WHY WONT MOVE JOB  28:43"
   V1348 = "CHOOSES WAY WORKS  28:44"
   V1349 = "LIKE MORE CHOICE   28:45"
   V1350 = "WTR WKD-69 (R)     28:46"
   V1351 = "THINKING ABT WRK(R)28:47"
   V1352 = "OCCUPATION-HEAD(R) 28:48"
   V1353 = "WEEKSWKD-HEAD(R)28:49-50"
   V1354 = "HRS/WK WKD HD(R)28:51-52"
   V1355 = "NEW JOB NEXT YR?(R)28:53"
   V1356 = "KIND OF NEW JOB (R)28:54"
   V1357 = "POSSIBLE WAGE(R)28:55-57"
   V1358 = "TRNING NEW JOB?(R) 28:58"
   V1359 = "DOING ABT NU JOB(R)28:59"
   V1360 = "#PLACES APPLIED(R) 28:60"
   V1361 = "JOBS NOT WRTH IT(R)28:61"
   V1362 = "PAY/HR REJECT(R)28:62-64"
   V1363 = "THINKING WK FUT(R) 28:65"
   V1364 = "WRK DEPENDS ON(R)  28:66"
   V1365 = "MARITAL STATUS     29:10"
   V1366 = "DID WIFE WORK      29:11"
   V1367 = "OCCUPATION-WIFE    29:12"
   V1368 = "WEEK WIFE WORKED29:13-14"
   V1369 = "HRS / WEEK WIFE 29:15-16"
   V1370 = "EXPECT CHILDREN ?  29:18"
   V1371 = "LIMIT # CHILDREN ? 29:19"
   V1372 = "HAVE FERTILTIY PROB29:20"
   V1373 = "WHEN EXPECT CHILD  29:21"
   V1374 = "CONTROL TIME CHILD 29:22"
   V1375 = "WHO DOES HOUSEWORK 29:23"
   V1376 = "HRS/WK 1ST HSWKR29:24-25"
   V1377 = "OTHERS DO HOUSEWORK29:26"
   V1378 = "HELP FROM OUTSIDE? 29:27"
   V1379 = "PAY FOR HELP ?     29:28"
   V1380 = "HOW OFTN EAT TGTHR 29:29"
   V1381 = "TOT FARM RECEIPTS  29:31"
   V1382 = "OWN A BUSINESS     29:32"
   V1383 = "BUS INCORPORATED   29:33"
   V1384 = "INSURANCE,INHERIT  29:34"
   V1385 = "AMT SETTLEMENT BKT 29:35"
   V1386 = "69 Y HIGHER OR 68? 29:36"
   V1387 = "WHY INCOME DIFFRNT 29:37"
   V1388 = "UNUSUAL EXPENSES   29:38"
   V1389 = "WHY EXPENSES UNUSL 29:39"
   V1390 = "69 BETTER, OR 68 ? 29:40"
   V1391 = "WHY 69/8 BETTER 1ST29:41"
   V1392 = "WHY 69/8 BETTER 2ND29:42"
   V1393_1 = "2 WAYS 69/8 BTR 29:41-42 RESP 1"
   V1393_2 = "2 WAYS 69/8 BTR 29:41-42 RESP 2"
   V1394 = "LOT OR LITTLE BTR  29:43"
   V1395 = "NXT FEW YRS OUTLOOK29:44"
   V1396 = "1ST REASON OUTLOOK 29:45"
   V1397 = "2ND REASON OUTLOOK 29:46"
   V1398_1 = "2 REASONS OUTLK 29:45-46 RESP 1"
   V1398_2 = "2 REASONS OUTLK 29:45-46 RESP 2"
   V1399 = "ANY OUTSIDE DEPS?  29:47"
   V1400 = "NR OUTSIDE DEPS    29:48"
   V1401 = "NR DEP >HALF SUPPT 29:49"
   V1402 = "WOULD HELP RELATIVE29:50"
   V1403 = "ANY SAVINGS ?      29:51"
   V1404 = "2 MONTHS Y SAVED   29:52"
   V1405 = "2 MO Y SAVD IN SYRS29:53"
   V1406 = "MEDICAL INSURANCE  29:54"
   V1407 = "ENTIRE FAMILY INSRD29:55"
   V1408 = "FREE MEDICAL CARE? 29:56"
   V1409 = "DISAB LIM KIND WRK 29:57"
   V1410 = "DISAB LIM AMT WRK  29:58"
   V1411 = "HEALTH LIM HSEWRK  29:59"
   V1412 = "HOW LONG LIMITED   29:60"
   V1413 = "HEALTH IMPROVING ? 29:61"
   V1414 = "OTHERS DISABLED ?  29:62"
   V1415 = "WHO ELSE DISABLED  29:63"
   V1416 = "AGE OF DISABLED 29:64-65"
   V1417 = "WHY OTHER DISABLED 29:66"
   V1418 = "OTHER EXTRA CARE   29:67"
   V1419 = "WHO REQ EXTRA CARE 29:68"
   V1420 = "AGE REQ EXTR CR 29:69-70"
   V1421 = "WHY REQ EXTRA CARE 29:71"
   V1422 = "WHAT DO SPARE TIME 30:10"
   V1423 = "2ND DO SPARE TIME  30:11"
   V1424_1 = "2 USES SPARE TIME30:1011 RESP 1"
   V1424_2 = "2 USES SPARE TIME30:1011 RESP 2"
   V1425 = "NR THINGS DONE S-T 30:12"
   V1426 = "COURSES OR LESSIONS30:13"
   V1427 = "WHAT COURSES       30:14"
   V1428 = "HRS OF TELEVISION  30:15"
   V1429 = "HOW OFTN NEWSPAPER 30:16"
   V1430 = "HOW OFTEN CHURCH   30:17"
   V1431 = "RELIGION           30:18"
   V1432 = "HOW OFTEN CLUBS    30:19"
   V1433 = "HOW OFTEN BAR+TAVRN30:20"
   V1434 = "UNION MEMBER       30:21"
   V1435 = "PLANS TO MAKE DIFF 30:22"
   V1436 = "WHAT PLANS FOR FUT 30:23"
   V1437 = "SURE LIFE WORK OUT 30:24"
   V1438 = "PLAN OR LIVE DAY-DY30:25"
   V1439 = "CARRY OUT PLANS OR 30:26"
   V1440 = "FINISH THINGS OR   30:27"
   V1441 = "LIKE DIFF-CHALLENG 30:28"
   V1442 = "RATHR SPND OR SAVE 30:29"
   V1443 = "PREFER CHANCE RAISE30:30"
   V1444 = "SATISFIED W SELF   30:31"
   V1445 = "HAVE LIMITATIONS   30:32"
   V1446 = "GET ANGRY EASILY   30:33"
   V1447 = "MATTR OTHRS THINK  30:34"
   V1448 = "TRUST MOST OTHERS  30:35"
   V1449 = "FIGR WAYS MOR MONEY30:36"
   V1450 = "THINK ABOUT FUTURE 30:37"
   V1451 = "AV MAN GETTNG BETTR30:38"
   V1452 = "LOT GOOD DONT DSRV 30:39"
   V1453 = "IDEAL # CHILDREN   30:40"
   V1454 = "ST DAD GREW UP  30:41-42"
   V1455 = "CNTY DAD GREW UP30:43-45"
   V1456 = "ST MOM GREW UP  30:46-47"
   V1457 = "CNTY MOM GREW UP30:48-50"
   V1458 = "FATHERS OCCUPATION 30:51"
   V1459 = "HEADS FIRST JOB    30:52"
   V1460 = "HEAD IN SAME OCCUP?30:53"
   V1461 = "SAME HEAD ?        31:10"
   V1462 = "AGE OLDST CHILD 31:11-12"
   V1463 = "AGE 2ND OLDEST  31:13-14"
   V1464 = "AGE 3RD OLDEST  31:15-16"
   V1465 = "NR CHILDREN HEAD31:17-18"
   V1466 = "NR CHILD HEAD BY25 31:19"
   V1467 = "NR SIBLINGS HEAD   31:20"
   V1468 = "HD ANY LIVNG BRTHR 31:21"
   V1469 = "AGE OLDEST BRTHR31:22-23"
   V1470 = "ED OLDST LIVNG BRTH31:24"
   V1471 = "OLDST BROTH WELLOFF31:25"
   V1472 = "HD ANY LIVNG SIST  31:26"
   V1473 = "AGE OLDST SISTR 31:27-28"
   V1474 = "ED OLDST LIVNG SIST31:29"
   V1475 = "OLDST SIST WELLOFF 31:30"
   V1476 = "HEAD GREW UP FARM  31:31"
   V1477 = "STATE H GREW UP 31:32-33"
   V1478 = "ST-CNTY GREW UP 31:34-36"
   V1479 = "NR REGIONS LVD IN  31:37"
   V1480 = "NR STATES H LVD IN 31:38"
   V1481 = "EVER MOVED FOR JOB 31:39"
   V1482 = "EVER REFUSED MOVE  31:40"
   V1483 = "HEADS PARENTS POOR 31:41"
   V1484 = "HDS FATHERS EDUC   31:42"
   V1485 = "EDUCATION OF HEAD  31:43"
   V1486 = "OTHR TRAINING HEAD 31:44"
   V1487 = "HEAD A VETERAN     31:45"
   V1488 = "WHO PRESENT ?      31:46"
   V1489 = "WHO RESPONDENT(REL)31:47"
   V1490 = "RACE               31:48"
   V1491 = "NUMBER OF CALLS    31:49"
   V1492 = "HOW CLEAN DU       31:50"
   V1493 = "READING MTL VISIBLE31:51"
   V1494 = "LANGUAGE PROBLEMS  31:52"
   V1495 = "HEAD DISFIGURED    31:53"
   V1496 = "IN CITY OF 5000+   31:54"
   V1497 = "NEAREST SMSA    31:55-57"
   V1498 = "DIST TO CNTR SMSA  31:58"
   V1499 = "TYPE OF STRUCTURE  31:59"
   V1500 = "NEIGHBORHOOD-LOWST 31:60"
   V1501 = "NEIGHBORHOOD-HGHST 31:61"
   V1502 = "DU IN PUB HOUSING  31:62"
   V1503 = "INSIDE TOILET      31:63"
   V1504 = "RUNNING WATER      31:64"
   V1505 = "DU NEED EXTEN REP  31:65"
   V1506 = "LRGST PLAC/SMSA PSU31:66"
   V1507 = "HOME PROD HRS(REV) 0V407"
   V1508 = "TOTAL NONLEISUR HRS0V408"
   V1509 = "YRLY PROP TAXES 0V409"
   V1510 = "IMPUTED RENT 0V410"
   V1511 = "HOUSE VALUE BKT 0V411"
   V1512 = "LEISURE NET TRAVEL0V412"
   V1513 = "LEISURE COMP 68 0V413"
   V1514 = "TOT FU MON INC OV414"
   V1515 = "BKT TOT FU MON INC 0V415"
   V1516 = "BKT LABOR INC HEAD 0V416"
   V1517 = "BKT LABOR INC WIFE 0V417"
   V1518 = "BKT H+W TAXABLE Y 0V418"
   V1519 = "BKT OTHERS TAXBL Y 0V419"
   V1520 = "BKT ADC            0V420"
   V1521 = "BKT OTHER WELFARE  0V421"
   V1522 = "BKT SOCIAL SEC 0V422"
   V1523 = "BKT OTHER RETIREMT 0V423"
   V1524 = "BKT UNEMP WORK COMP 0V42"
   V1525 = "BKT ALMNY CHLD SUP 0V425"
   V1526 = "BKT TOT TRNSFRS H& W0V426"
   V1527 = "MISC TRANSFERS 0V427"
   V1528 = "BKT MISC TRANSFRS 0V428"
   V1529 = "BKT OTHRS TRNSFR Y 0V429"
   V1530 = "MONEY Y/NEEDS 0V430"
   V1531 = "BKT MONEY Y/NEEDS 0V431"
   V1532 = "W-O MONEY 0V432"
   V1533 = "BKT W-O MONEY 0V433"
   V1534 = "FRE HELP FRM OTHRS 0V434"
   V1535 = "TOTAL REAL Y 0V435"
   V1536 = "BKT TOTAL REAL Y 0V436"
   V1537 = "TOTAL COST OF INC 0V437"
   V1538 = "REAL NET Y 0V438"
   V1539 = "BKT REAL NET Y 0V439"
   V1540 = "REAL NET Y/NEEDS 0V440"
   V1541 = "BKT RL NET Y/NEEDS 0V441"
   V1542 = "W-O NET REAL 0V442"
   V1543 = "BKT W-O NET REAL 0V443"
   V1544 = "COST OF HOUSING 0V444"
   V1545 = "BKT COST OF HOUSING 0V44"
   V1546 = "REAL NET (2)Y 0V466"
   V1547 = "BKT REAL NET (2)Y 0V447"
   V1548 = "NET (2) Y/NEEDS 0V448"
   V1549 = "BKT NET (2) Y/NEEDS 0V44"
   V1550 = "W-O NET (2)Y 0V450"
   V1551 = "BKT W-O NET (2)Y 0V451"
   V1552 = "NET Y-HOUSING 0V452"
   V1553 = "BKT NET Y-HOUSING 0V453"
   V1554 = "NET Y-HSNG/FD ND 0V454"
   V1555 = "BKT Y-HSNG/FD ND 0V455"
   V1556 = "W-O NET Y-HSNG 0V456"
   V1557 = "BKT W-O NET Y-HSNG 0V457"
   V1558 = "W-O NET (2) Y-HSNG 0V458"
   V1559 = "TOTAL FOOD CONS 0V459"
   V1560 = "BKT FOOD CONSMPTN 0V460"
   V1561 = "FOOD CONS/FD ND 0V461"
   V1562 = "BKT FOOD/FD ND 0V462"
   V1563 = "TOTAL FAMILY WORK 0V463"
   V1564 = "BKT TOT FAM WORK 0V464"
   V1565 = "FAM WORK INCL TRAV 0V465"
   V1566 = "BKT WORK INCL TRAV 0V466"
   V1567 = "HEADS AVG HRLY ERN 0V467"
   V1568 = "BKT HEAD AV HR ERN 0V468"
   V1569 = "WIFE AV HRLY EARN 0V469"
   V1570 = "BKT WF AV HRLY ERN 0V470"
   V1571 = "RESERVE FUNDS 0V471"
   V1572 = "CURRENT REGION 0V472"
   V1573 = "REGION GREW UP 0V473"
   V1574 = "RGN FATHER GREW UP 0V474"
   V1575 = "RGN MOTHER GREW UP 0V475"
   V1576 = "GEOGRAPHIC MOBILITY 0V47"
   V1577 = "ACCURACY MONEY INC 0V477"
   V1578 = "ACCURACY HOURS 0V478"
   V1579 = "ACCURACY REAL INC 0V479"
   V1580 = "#MINOR ASSIGNMTS 0V480"
   V1581 = "MAJOR ASSIGNMTS 0V481"
   V1582 = "VALUE PER ROOM 0V482"
   V1583 = "BKT VALUE PER ROOM 0V483"
   V1584 = "BKT CAR VALUE 0V484"
   V1585 = "BKT OV-TIM HR WAGE 0V485"
   V1586 = "BKT REG HRLY WAGE 0V486"
   V1587 = "BKT PAY 2ND JOB 0V487"
   V1588 = "ACTUAL-REQD ROOMS 0V488"
   V1589 = "PERSONS PER ROOM 0V489"
   V1590 = "BKT PERSONS/RM 0V490"
   V1591 = "NUMBER OF ADULTS 0V491"
   V1592 = "HOUSEWORK H+W 0V492"
   V1593 = "HOUSING NBHD QUAL 0V493"
   V1594 = "EFFICACY &  PLANNING 0V49"
   V1595 = "TRUST OR HOSTILITY 0V495"
   V1596 = "SCRAMBLE FOR WORK 0V496"
   V1597 = "ASPIRATION AMBITIN 0V497"
   V1598 = "REAL EARNING ACTS 0V498"
   V1599 = "ECONOMIZING 0V499"
   V1600 = "RISK AVOIDANCE 0V500"
   V1601 = "HORIZON PROXIES 0V501"
   V1602 = "CONNECTEDNESS 0V502"
   V1603 = "MONEY EARNING ACTS 0V503"
   V1604 = "NON-LEISURE COMP 0V504"
   V1605 = "ANNUAL FOOD STD 0V505"
   V1606 = "ONE DIGIT FAM SIZE 0V506"
   V1607 = "BKT AGE OLDST BROT 0V507"
   V1608 = "BKT AGE OLDST SIST 0V508"
   V1609 = "WEIGHT             0V509"
   V1610 = "DEC MONEY          0V510"
   V1611 = "DEC MONEY/NEEDS    0V511"
   V1612 = "DEC W/O MONEY      0V512"
   V1613 = "DEC REAL NET       0V513"
   V1614 = "DEC REAL NET/NEEDS 0V514"
   V1615 = "DEC W-O REAL NET   0V515"
   V1616 = "DEC REAL NET-HSNG  0V516"
   V1617 = "DEC RL NET HSG NDS 0V517"
   V1618 = "DEC W-O RL NT HSNDS0V518"
   V1619 = "UNSKIL MAKE LABOR 70"
   V1620 = "UNSKIL FEMALE LABOR 70"
   V1621 = "COMPAR W-NONW MKTS 70"
   V1622 = "TYPICAL WAGE MALE 70"
   V1623 = "TYPICAL WAGE FEMALE 70"
   V1624 = "UNEMPLOYMENT RATE 70"
   V1625 = "UNSKIL TEMP LABOR 69"
   V1626 = "TYPICAL WAGE 69"
   V1627 = "UNEMPLOYMENT RATE 69"
   V1701 = "68 CNTY-POP/SQ MILE"
   V1702 = "68 CNTY-PCHG POP 60-70"
   V1703 = "68 CNTY-PNET MIG 60-70"
   V1704 = "68 CNTY-MEDIAN SCH YRS"
   V1705 = "68 CNTY P>=4YR COLL"
   V1706 = "68 CNTY-PFM CLF W/ HUSB"
   V1707 = "68 CNTY-PUNEMP IN CLF"
   V1708 = "68 CNTY-PWKR-PUB TRANS"
   V1709 = "68 CNTY-PFAM Y<3000"
   V1710 = "68 CNTY-PFAM Y>=25000"
   V1711 = "68 CNTY-MEDIAN FAM Y"
   V1712 = "68 CNTY /CAPITA MONEY Y"
   V1713 = "68 CNTY-PFAM<LOW Y LEVEL"
   V1714 = "68 CNTY-PCHG HSG U 60-70"
   V1715 = "68 CNTY MEDIAN ROOM/UNIT"
   V1716 = "68 CNTY-PU BLT AFTR 60"
   V1717 = "68 CNTY-HOMEOWN VAC RATE"
   V1718 = "68 CNTY RENTAL VAC RATE"
   V1719 = "68 CNTY-POWNER OCC UNIT"
   V1720 = "68 CNTY-MD VAL OWN OCC U"
   V1721 = "68 CNTY-MD RENT RTR OC U"
   V1722 = "68 CNTY-PU HD MOV 65-70"
   V1723 = "68 CNTY /CAP LOC GT EXPD"
   V1724 = "68 CNTY-PL GVT EXPD EDUC"
   V1725 = "74 CNTY-POP/SQ MILE"
   V1726 = "74 CNTY-PCHG POP 60-70"
   V1727 = "74 CNTY-PNET MIG 60-70"
   V1728 = "74 CNTY-MEDIAN SCH YRS"
   V1729 = "74 CNTY P>=4YR COLL"
   V1730 = "74 CNTY-PFM CLF W/ HUSB"
   V1731 = "74 CNTY-PUNEMP IN CLF"
   V1732 = "74 CNTY-PWKR-PUB TRANS"
   V1733 = "74 CNTY-PFAM Y<3000"
   V1734 = "74 CNTY-PFAM Y>=25000"
   V1735 = "74 CNTY-MEDIAN FAM Y"
   V1736 = "74 CNTY /CAPITA MONEY Y"
   V1737 = "74 CNTY-PFAM<LOW Y LEVEL"
   V1738 = "74 CNTY-PCHG HSG U 60-70"
   V1739 = "74 CNTY MEDIAN ROOM/UNIT"
   V1740 = "74 CNTY-PU BLT AFT 60"
   V1741 = "74 CNTY-HOMEOWN VAC RATE"
   V1742 = "74 CNTY RENTAL VAC RATE"
   V1743 = "74 CNTY-POWNER OCC UNIT"
   V1744 = "74 CNTY-MD VAL OWN OCC U"
   V1745 = "74 CNTY-MD RENT RTR OC U"
   V1746 = "74 CNTY-PU HD MOVE 65-70"
   V1747 = "74 CNTY /CAP LOC GT EXPD"
   V1748 = "74 CNTY-PL GVT EXPD EDUC"
   V1749 = "68 CPI ALL ITEMS"
   V1750 = "68 CPI FOOD"
   V1751 = "68 CPI HOUSING"
   V1752 = "69 CPI ALL ITEMS"
   V1753 = "69 CPI FOOD"
   V1754 = "69 CPI HOUSING"
   V1755 = "70 CPI ALL ITEMS"
   V1756 = "70 CPI FOOD"
   V1757 = "70 CPI HOUSING"
   V1758 = "71 CPI ALL ITEMS"
   V1759 = "71 CPI FOOD"
   V1760 = "71 CPI HOUSING"
   V1761 = "72 CPI ALL ITEMS"
   V1762 = "72 CPI FOOD"
   V1763 = "72 CPI HOUSINGMS"
   V1764 = "AMT PAID FOOD STAMPS"
   V1765 = "$  FOOD BOUGHT W/ STAMPS"
   V1766 = "HOUSEHOLD ID # 70"
   V1767 = "FU PRIMACY WITHIN HU";

* USER-DEFINED MISSING VALUE RECODE TO SAS SYSMIS;

IF V1228 GE 99999 THEN V1228=.;
IF V1236 GE 9 THEN V1236=.;
IF V1237 GE 999 THEN V1237=.;
IF V1244 GE 9 THEN V1244=.;
IF V1245 GE 9 THEN V1245=.;
IF V1246 GE 9 THEN V1246=.;
IF V1247 GE 9 THEN V1247=.;
IF V1248 GE 9 THEN V1248=.;
IF V1249 GE 9 THEN V1249=.;
IF V1250 GE 9 THEN V1250=.;
IF V1251 GE 9 THEN V1251=.;
IF V1252 GE 9 THEN V1252=.;
IF V1253 GE 9 THEN V1253=.;
IF V1254 GE 9 THEN V1254=.;
IF V1255 GE 99 THEN V1255=.;
IF V1256 GE 9 THEN V1256=.;
IF V1257 GE 9 THEN V1257=.;
IF V1258 GE 9 THEN V1258=.;
IF V1259 GE 9 THEN V1259=.;
IF V1260 GE 9 THEN V1260=.;
IF V1261 GE 9 THEN V1261=.;
IF V1262 GE 9 THEN V1262=.;
IF V1263 GE 9 THEN V1263=.;
IF V1265 GE 9 THEN V1265=.;
IF V1266 GE 9 THEN V1266=.;
IF V1267 GE 9 THEN V1267=.;
IF V1268 GE 9 THEN V1268=.;
IF V1269 GE 9 THEN V1269=.;
IF V1270 GE 9 THEN V1270=.;
IF V1271 GE 9 THEN V1271=.;
IF V1272 GE 9 THEN V1272=.;
IF V1273 GE 9 THEN V1273=.;
IF V1274 GE 9 THEN V1274=.;
IF V1275 GE 9 THEN V1275=.;
IF V1276 GE 9 THEN V1276=.;
IF V1277 GE 9 THEN V1277=.;
IF V1280 GE 9 THEN V1280=.;
IF V1281 GE 9 THEN V1281=.;
IF V1282 GE 9 THEN V1282=.;
IF V1283 GE 9 THEN V1283=.;
IF V1284 GE 9 THEN V1284=.;
IF V1285 GE 9 THEN V1285=.;
IF V1286 GE 9 THEN V1286=.;
IF V1287 GE 99 THEN V1287=.;
IF V1288 GE 9 THEN V1288=.;
IF V1289 GE 99 THEN V1289=.;
IF V1290 GE 9 THEN V1290=.;
IF V1291 GE 99 THEN V1291=.;
IF V1292 GE 99 THEN V1292=.;
IF V1293 GE 99 THEN V1293=.;
IF V1294 GE 9 THEN V1294=.;
IF V1295 GE 999 THEN V1295=.;
IF V1296 GE 9 THEN V1296=.;
IF V1297 GE 999 THEN V1297=.;
IF V1298 GE 9 THEN V1298=.;
IF V1300 GE 9 THEN V1300=.;
IF V1301 GE 999 THEN V1301=.;
IF V1302 GE 99 THEN V1302=.;
IF V1303 GE 99 THEN V1303=.;
IF V1304 GE 9 THEN V1304=.;
IF V1305 GE 9 THEN V1305=.;
IF V1306 GE 9 THEN V1306=.;
IF V1307 GE 9 THEN V1307=.;
IF V1308 GE 9 THEN V1308=.;
IF V1309 GE 99 THEN V1309=.;
IF V1310 GE 9 THEN V1310=.;
IF V1311 GE 9 THEN V1311=.;
IF V1312 GE 9 THEN V1312=.;
IF V1313 GE 9 THEN V1313=.;
IF V1314 GE 9 THEN V1314=.;
IF V1315 GE 9 THEN V1315=.;
IF V1316 GE 999 THEN V1316=.;
IF V1317 GE 9 THEN V1317=.;
IF V1318 GE 9 THEN V1318=.;
IF V1319 GE 9 THEN V1319=.;
IF V1320 GE 9 THEN V1320=.;
IF V1321 GE 999 THEN V1321=.;
IF V1322 GE 9 THEN V1322=.;
IF V1323 GE 9 THEN V1323=.;
IF V1324 GE 9 THEN V1324=.;
IF V1327 GE 999 THEN V1327=.;
IF V1328 GE 9 THEN V1328=.;
IF V1329 GE 9 THEN V1329=.;
IF V1330 GE 9 THEN V1330=.;
IF V1332 GE 9 THEN V1332=.;
IF V1333 GE 99 THEN V1333=.;
IF V1334 GE 99 THEN V1334=.;
IF V1335 GE 99 THEN V1335=.;
IF V1336 GE 99 THEN V1336=.;
IF V1337 GE 9 THEN V1337=.;
IF V1338 GE 99 THEN V1338=.;
IF V1339 GE 9 THEN V1339=.;
IF V1340 GE 9 THEN V1340=.;
IF V1341 GE 9 THEN V1341=.;
IF V1342 GE 9 THEN V1342=.;
IF V1343 GE 9 THEN V1343=.;
IF V1344 GE 999 THEN V1344=.;
IF V1345 GE 9 THEN V1345=.;
IF V1346 GE 999 THEN V1346=.;
IF V1347 GE 9 THEN V1347=.;
IF V1348 GE 9 THEN V1348=.;
IF V1349 GE 9 THEN V1349=.;
IF V1350 GE 9 THEN V1350=.;
IF V1351 GE 9 THEN V1351=.;
IF V1353 GE 99 THEN V1353=.;
IF V1354 GE 99 THEN V1354=.;
IF V1355 GE 9 THEN V1355=.;
IF V1356 GE 9 THEN V1356=.;
IF V1357 GE 999 THEN V1357=.;
IF V1358 GE 9 THEN V1358=.;
IF V1359 GE 9 THEN V1359=.;
IF V1360 GE 9 THEN V1360=.;
IF V1361 GE 9 THEN V1361=.;
IF V1362 GE 999 THEN V1362=.;
IF V1363 GE 9 THEN V1363=.;
IF V1364 GE 9 THEN V1364=.;
IF V1366 GE 9 THEN V1366=.;
IF V1368 GE 99 THEN V1368=.;
IF V1369 GE 99 THEN V1369=.;
IF V1370 GE 9 THEN V1370=.;
IF V1371 GE 9 THEN V1371=.;
IF V1372 GE 9 THEN V1372=.;
IF V1373 GE 9 THEN V1373=.;
IF V1374 GE 9 THEN V1374=.;
IF V1375 GE 9 THEN V1375=.;
IF V1376 GE 99 THEN V1376=.;
IF V1377 GE 9 THEN V1377=.;
IF V1378 GE 9 THEN V1378=.;
IF V1379 GE 9 THEN V1379=.;
IF V1380 GE 9 THEN V1380=.;
IF V1381 GE 9 THEN V1381=.;
IF V1382 GE 9 THEN V1382=.;
IF V1383 GE 9 THEN V1383=.;
IF V1384 GE 9 THEN V1384=.;
IF V1385 GE 9 THEN V1385=.;
IF V1386 GE 9 THEN V1386=.;
IF V1387 GE 9 THEN V1387=.;
IF V1388 GE 9 THEN V1388=.;
IF V1389 GE 9 THEN V1389=.;
IF V1390 GE 9 THEN V1390=.;
IF V1391 GE 9 THEN V1391=.;
IF V1392 GE 9 THEN V1392=.;
IF V1393_1 GE 9 THEN V1393_1=.;
IF V1393_2 GE 9 THEN V1393_2=.;
IF V1394 GE 9 THEN V1394=.;
IF V1395 GE 9 THEN V1395=.;
IF V1396 GE 9 THEN V1396=.;
IF V1397 GE 9 THEN V1397=.;
IF V1398_1 GE 9 THEN V1398_1=.;
IF V1398_2 GE 9 THEN V1398_2=.;
IF V1399 GE 9 THEN V1399=.;
IF V1400 GE 9 THEN V1400=.;
IF V1401 GE 9 THEN V1401=.;
IF V1402 GE 9 THEN V1402=.;
IF V1403 GE 9 THEN V1403=.;
IF V1404 GE 9 THEN V1404=.;
IF V1405 GE 9 THEN V1405=.;
IF V1406 GE 9 THEN V1406=.;
IF V1407 GE 9 THEN V1407=.;
IF V1408 GE 9 THEN V1408=.;
IF V1409 GE 9 THEN V1409=.;
IF V1410 GE 9 THEN V1410=.;
IF V1411 GE 9 THEN V1411=.;
IF V1412 GE 9 THEN V1412=.;
IF V1413 GE 9 THEN V1413=.;
IF V1414 GE 9 THEN V1414=.;
IF V1415 GE 9 THEN V1415=.;
IF V1416 GE 99 THEN V1416=.;
IF V1417 GE 9 THEN V1417=.;
IF V1418 GE 9 THEN V1418=.;
IF V1419 GE 9 THEN V1419=.;
IF V1420 GE 99 THEN V1420=.;
IF V1421 GE 9 THEN V1421=.;
IF V1422 GE 9 THEN V1422=.;
IF V1423 GE 9 THEN V1423=.;
IF V1424_1 GE 9 THEN V1424_1=.;
IF V1424_2 GE 9 THEN V1424_2=.;
IF V1425 GE 9 THEN V1425=.;
IF V1426 GE 9 THEN V1426=.;
IF V1427 GE 9 THEN V1427=.;
IF V1428 GE 9 THEN V1428=.;
IF V1429 GE 9 THEN V1429=.;
IF V1430 GE 9 THEN V1430=.;
IF V1431 GE 9 THEN V1431=.;
IF V1432 GE 9 THEN V1432=.;
IF V1433 GE 9 THEN V1433=.;
IF V1434 GE 9 THEN V1434=.;
IF V1435 GE 9 THEN V1435=.;
IF V1436 GE 9 THEN V1436=.;
IF V1437 GE 9 THEN V1437=.;
IF V1438 GE 9 THEN V1438=.;
IF V1439 GE 9 THEN V1439=.;
IF V1440 GE 9 THEN V1440=.;
IF V1441 GE 9 THEN V1441=.;
IF V1442 GE 9 THEN V1442=.;
IF V1443 GE 9 THEN V1443=.;
IF V1444 GE 9 THEN V1444=.;
IF V1445 GE 9 THEN V1445=.;
IF V1446 GE 9 THEN V1446=.;
IF V1447 GE 9 THEN V1447=.;
IF V1448 GE 9 THEN V1448=.;
IF V1449 GE 9 THEN V1449=.;
IF V1450 GE 9 THEN V1450=.;
IF V1451 GE 9 THEN V1451=.;
IF V1452 GE 9 THEN V1452=.;
IF V1453 GE 9 THEN V1453=.;
IF V1454 GE 99 THEN V1454=.;
IF V1455 GE 999 THEN V1455=.;
IF V1456 GE 99 THEN V1456=.;
IF V1457 GE 999 THEN V1457=.;
IF V1458 GE 9 THEN V1458=.;
IF V1459 GE 9 THEN V1459=.;
IF V1460 GE 9 THEN V1460=.;
IF V1461 GE 9 THEN V1461=.;
IF V1462 GE 99 THEN V1462=.;
IF V1463 GE 99 THEN V1463=.;
IF V1464 GE 99 THEN V1464=.;
IF V1465 GE 99 THEN V1465=.;
IF V1466 GE 9 THEN V1466=.;
IF V1467 GE 9 THEN V1467=.;
IF V1468 GE 9 THEN V1468=.;
IF V1469 GE 99 THEN V1469=.;
IF V1470 GE 9 THEN V1470=.;
IF V1471 GE 9 THEN V1471=.;
IF V1472 GE 9 THEN V1472=.;
IF V1473 GE 99 THEN V1473=.;
IF V1474 GE 9 THEN V1474=.;
IF V1475 GE 9 THEN V1475=.;
IF V1476 GE 9 THEN V1476=.;
IF V1477 GE 99 THEN V1477=.;
IF V1478 GE 999 THEN V1478=.;
IF V1479 GE 9 THEN V1479=.;
IF V1480 GE 9 THEN V1480=.;
IF V1481 GE 9 THEN V1481=.;
IF V1482 GE 9 THEN V1482=.;
IF V1483 GE 9 THEN V1483=.;
IF V1484 GE 9 THEN V1484=.;
IF V1485 GE 9 THEN V1485=.;
IF V1486 GE 9 THEN V1486=.;
IF V1487 GE 9 THEN V1487=.;
IF V1488 GE 9 THEN V1488=.;
IF V1489 GE 9 THEN V1489=.;
IF V1490 GE 9 THEN V1490=.;
IF V1491 GE 9 THEN V1491=.;
IF V1492 GE 9 THEN V1492=.;
IF V1493 GE 9 THEN V1493=.;
IF V1494 GE 9 THEN V1494=.;
IF V1495 GE 9 THEN V1495=.;
IF V1496 GE 9 THEN V1496=.;
IF V1497 GE 9 THEN V1497=.;
IF V1498 GE 9 THEN V1498=.;
IF V1499 GE 9 THEN V1499=.;
IF V1500 GE 9 THEN V1500=.;
IF V1501 GE 9 THEN V1501=.;
IF V1502 GE 9 THEN V1502=.;
IF V1503 GE 9 THEN V1503=.;
IF V1504 GE 9 THEN V1504=.;
IF V1505 GE 9 THEN V1505=.;
IF V1571=9 THEN V1571=.;
IF V1572=9 THEN V1572=.;
IF V1573=9 THEN V1573=.;
IF V1574=9 THEN V1574=.;
IF V1575=9 THEN V1575=.;
IF V1576=9 THEN V1576=.;
IF V1582=99999 THEN V1582=.;
IF V1583=9 THEN V1583=.;
IF V1585=9 THEN V1585=.;
IF V1586=9 THEN V1586=.;
IF V1587 GE 9 THEN V1587=.;
IF V1588=9 THEN V1588=.;
IF V1589=9.9 THEN V1589=.;
IF V1590=9 THEN V1590=.;
IF V1607 GE 9 THEN V1607=.;
IF V1608 GE 9 THEN V1608=.;
IF V1619 GE 9 THEN V1619=.;
IF V1620 GE 9 THEN V1620=.;
IF V1621 GE 9 THEN V1621=.;
IF V1622 GE 9 THEN V1622=.;
IF V1623 GE 9 THEN V1623=.;
IF V1624 GE 9 THEN V1624=.;
IF V1625 GE 9 THEN V1625=.;
IF V1626 GE 9 THEN V1626=.;
IF V1627 GE 9 THEN V1627=.;
IF V1701=99999 THEN V1701=.;
IF V1702=999.9 THEN V1702=.;
IF V1703=999.9 THEN V1703=.;
IF V1704=99.9 THEN V1704=.;
IF V1705=99.9 THEN V1705=.;
IF V1706=99.9 THEN V1706=.;
IF V1707=99.9 THEN V1707=.;
IF V1708=99.9 THEN V1708=.;
IF V1709=99.9 THEN V1709=.;
IF V1710=99.9 THEN V1710=.;
IF V1711=99999 THEN V1711=.;
IF V1712=99999 THEN V1712=.;
IF V1713=99.9 THEN V1713=.;
IF V1714=999.9 THEN V1714=.;
IF V1715=9.9 THEN V1715=.;
IF V1716=99.9 THEN V1716=.;
IF V1717=99.9 THEN V1717=.;
IF V1718=99.9 THEN V1718=.;
IF V1719=99.9 THEN V1719=.;
IF V1720=99999 THEN V1720=.;
IF V1721=999 THEN V1721=.;
IF V1722=99.9 THEN V1722=.;
IF V1723=9999 THEN V1723=.;
IF V1724=99.9 THEN V1724=.;
IF V1725=99999 THEN V1725=.;
IF V1726=999.9 THEN V1726=.;
IF V1727=999.9 THEN V1727=.;
IF V1728=99.9 THEN V1728=.;
IF V1729=99.9 THEN V1729=.;
IF V1730=99.9 THEN V1730=.;
IF V1731=99.9 THEN V1731=.;
IF V1732=99.9 THEN V1732=.;
IF V1733=99.9 THEN V1733=.;
IF V1734=99.9 THEN V1734=.;
IF V1735=99999 THEN V1735=.;
IF V1736=99999 THEN V1736=.;
IF V1737=99.9 THEN V1737=.;
IF V1738=999.9 THEN V1738=.;
IF V1739=9.9 THEN V1739=.;
IF V1740=99.9 THEN V1740=.;
IF V1741=99.9 THEN V1741=.;
IF V1742=99.9 THEN V1742=.;
IF V1743=99.9 THEN V1743=.;
IF V1744=99999 THEN V1744=.;
IF V1745=999 THEN V1745=.;
IF V1746=99.9 THEN V1746=.;
IF V1747=9999 THEN V1747=.;
IF V1748=99.9 THEN V1748=.;
IF V1749=999 THEN V1749=.;
IF V1750=999 THEN V1750=.;
IF V1751=999 THEN V1751=.;
IF V1752=999 THEN V1752=.;
IF V1753=999 THEN V1753=.;
IF V1754=999 THEN V1754=.;
IF V1755=999 THEN V1755=.;
IF V1756=999 THEN V1756=.;
IF V1757=999 THEN V1757=.;
IF V1758=999 THEN V1758=.;
IF V1759=999 THEN V1759=.;
IF V1760=999 THEN V1760=.;
IF V1761=999 THEN V1761=.;
IF V1762=999 THEN V1762=.;
IF V1763=999 THEN V1763=.;
IF V1764=9999 THEN V1764=.;
IF V1765=9999 THEN V1765=.;

 
file rawdat lrecl=1145;
put    
v1102
v1109
v1122
v1123
v1128
v1129
v1133
v1134
v1138
v1139
v1148
v1149
v1170
v1175
v1176
v1183
v1184
v1185
v1186
v1196
v1197
v1198
v1199
v1203
v1204
v1205
v1208
v1220
v1221
v1222
v1224
v1225
v1236
v1238
v1239
v1240
v1241
v1254
v1264
v1265
v1274
v1275
v1278
v1280
v1282
v1292
v1293
v1332
v1333
v1334
v1365
v1368
v1369
v1385
v1400
v1409
v1461
v1485
v1490
v1514
v1572
v1577
v1609
v30046
;

 proc means;
 run; 
